/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.commoncrawl.io.internal.NIOBufferList;

public class NIOBufferListOutputStream
extends OutputStream {
    private NIOBufferList _target = null;
    private ByteBuffer _buffer = null;

    public NIOBufferListOutputStream(NIOBufferList buffer) {
        this._target = buffer;
    }

    public void write(int b) throws IOException {
        if (this.capacity() == 0) {
            this.grow();
        }
        this._buffer.put((byte)b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (len != 0) {
            if (this.capacity() == 0) {
                this.grow();
            }
            int sizeAvailable = this._buffer.remaining();
            int sizeToWrite = Math.min(sizeAvailable, len);
            this._buffer.put(b, off, sizeToWrite);
            off += sizeToWrite;
            len -= sizeToWrite;
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    private final int capacity() {
        return this._buffer != null ? this._buffer.remaining() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void grow() throws IOException {
        NIOBufferListOutputStream nIOBufferListOutputStream = this;
        synchronized (nIOBufferListOutputStream) {
            if (this._buffer != null) {
                this._target.write(this._buffer);
            }
            this._buffer = this._target.getWriteBuf();
        }
    }

    public void flush() throws IOException {
        if (this._buffer != null && this._buffer.position() != 0) {
            this._target.write(this._buffer);
            this._buffer = null;
        }
        this._target.flush();
    }

    public void reset() {
        this._buffer = null;
    }
}

