/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.commoncrawl.io.internal.NIOBufferList;

public class NIOBufferListInputStream
extends InputStream {
    private NIOBufferList _source = null;
    private ByteBuffer _buffer = null;

    public NIOBufferListInputStream(NIOBufferList source) {
        this._source = source;
    }

    public void reset() {
        this._buffer = null;
    }

    private void getNext() throws IOException {
        this._buffer = null;
        this._buffer = this._source.read();
    }

    private void ensureBuffer() throws IOException {
        if (this._buffer == null || this._buffer.remaining() == 0) {
            this.getNext();
        }
    }

    public int read() throws IOException {
        this.ensureBuffer();
        if (this._buffer != null) {
            return this._buffer.get() & 0xFF;
        }
        return -1;
    }

    public int available() throws IOException {
        int available = 0;
        if (this._buffer != null) {
            available += this._buffer.remaining();
        }
        return available += this._source.available();
    }

    public NIOBufferListInputStream subStream(int desiredStreamSize) throws IOException {
        if (this.available() < desiredStreamSize) {
            throw new EOFException();
        }
        NIOBufferList bufferList = new NIOBufferList();
        int sizeOut = 0;
        int len = desiredStreamSize;
        while (len != 0) {
            ByteBuffer buffer;
            int sizeToRead;
            this.ensureBuffer();
            if (this._buffer == null) break;
            int sizeAvailable = this._buffer.remaining();
            if (sizeAvailable <= (sizeToRead = Math.min(sizeAvailable, len))) {
                buffer = this._buffer.slice();
                buffer.position(buffer.limit());
                bufferList.write(buffer);
                this._buffer = null;
            } else {
                buffer = this._buffer.slice();
                buffer.limit(buffer.position() + sizeToRead);
                buffer.position(buffer.limit());
                bufferList.write(buffer);
                this._buffer.position(this._buffer.position() + sizeToRead);
            }
            len -= sizeToRead;
            sizeOut += sizeToRead;
        }
        bufferList.flush();
        if (sizeOut != desiredStreamSize) {
            throw new EOFException();
        }
        return new NIOBufferListInputStream(bufferList);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int sizeOut = 0;
        while (len != 0) {
            this.ensureBuffer();
            if (this._buffer == null) break;
            int sizeAvailable = this._buffer.remaining();
            int sizeToRead = Math.min(sizeAvailable, len);
            this._buffer.get(b, off, sizeToRead);
            len -= sizeToRead;
            sizeOut += sizeToRead;
            off += sizeToRead;
        }
        return sizeOut != 0 ? sizeOut : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long skipAmount) throws IOException {
        long skipAmountOut = 0L;
        while (skipAmount != 0L) {
            this.ensureBuffer();
            if (this._buffer == null) break;
            long sizeAvailable = this._buffer.remaining();
            int sizeToSkip = (int)Math.min(sizeAvailable, skipAmount);
            this._buffer.position(this._buffer.position() + sizeToSkip);
            skipAmount -= (long)sizeToSkip;
            skipAmountOut += (long)sizeToSkip;
        }
        return skipAmount;
    }

    public void close() throws IOException {
        if (this._buffer != null && this._buffer.remaining() != 0 && this._source != null) {
            this._source.putBack(this._buffer);
        }
        super.close();
    }
}

