/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.commoncrawl.io.shared.NIODataSink;

public final class NIOBufferList {
    private static final int MIN_BUF_SIZE = 4096;
    private static final int MAX_BUF_SIZE = 65536;
    private LinkedList<ByteBuffer> _bufferList = new LinkedList();
    private int _bufferListBytes = 0;
    private ByteBuffer _readBuffer = null;
    private ByteBuffer _writeBuffer = null;
    private int _lastWriteBufSize = 0;
    private int _minBufferSize = 4096;
    private int _maxBufferSize = 65536;
    private NIODataSink _consumer = null;
    private ReentrantLock _readLock = null;
    private Condition _readEvent = null;

    public synchronized NIODataSink getSink() {
        return this._consumer;
    }

    public synchronized void setSink(NIODataSink consumer) {
        this._consumer = consumer;
    }

    public synchronized void setReadEvent(ReentrantLock lock, Condition readEvent) {
        this._readLock = lock;
        this._readEvent = readEvent;
    }

    public void setMinBufferSize(int size) {
        this._minBufferSize = size;
    }

    public void setMaxBufferSize(int size) {
        this._maxBufferSize = size;
    }

    public synchronized void reset() {
        this._bufferList.clear();
        this._readBuffer = null;
        this._writeBuffer = null;
    }

    public synchronized boolean isDataAvailable() {
        if (this._readBuffer != null && this._readBuffer.remaining() != 0) {
            return true;
        }
        return this._bufferListBytes != 0;
    }

    public synchronized int available() {
        int size = 0;
        if (this._readBuffer != null) {
            size += this._readBuffer.remaining();
        }
        return size += this._bufferListBytes;
    }

    public long skip(long skipAmount) throws IOException {
        long amountSkipped = 0L;
        ByteBuffer readBuffer = this._getNextReadBuf();
        while (skipAmount != 0L && readBuffer != null) {
            long bytesAvailable = Math.min(skipAmount, (long)readBuffer.remaining());
            readBuffer.position(readBuffer.position() + (int)bytesAvailable);
            amountSkipped += bytesAvailable;
            skipAmount -= bytesAvailable;
            readBuffer = this._getNextReadBuf();
        }
        return amountSkipped != 0L ? amountSkipped : -1L;
    }

    public CRLFReadState readCRLFLine(StringBuffer accumulator, int lineMax, CRLFReadState lastReadState) throws IOException {
        ByteBuffer currentBuffer = null;
        while (lastReadState != CRLFReadState.DONE && (currentBuffer = this._getNextReadBuf()) != null) {
            while (currentBuffer.position() < currentBuffer.limit()) {
                char currentChar = (char)currentBuffer.get();
                if (lastReadState != CRLFReadState.GOT_CR && currentChar == '\r') {
                    lastReadState = CRLFReadState.GOT_CR;
                    continue;
                }
                if (lastReadState == CRLFReadState.GOT_CR && currentChar == '\n') {
                    return CRLFReadState.DONE;
                }
                lastReadState = CRLFReadState.NONE;
                accumulator.append(currentChar);
                if (accumulator.length() <= lineMax) continue;
                throw new IOException("Line Size Limit Reached With No Terminator!");
            }
        }
        return lastReadState;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        int bytesRead = 0;
        ByteBuffer readBuffer = this._getNextReadBuf();
        while (count > 0 && readBuffer != null) {
            int bytesAvailable = Math.min(count, readBuffer.remaining());
            readBuffer.get(buffer, offset, bytesAvailable);
            bytesRead += bytesAvailable;
            offset += bytesAvailable;
            count -= bytesAvailable;
            readBuffer = this._getNextReadBuf();
        }
        return bytesRead != 0 ? bytesRead : -1;
    }

    public synchronized void putBack(ByteBuffer existingReadBuffer) throws IOException {
        if (existingReadBuffer == null) {
            throw new IOException("Invalid Call to putBack - incoming Buffer is null!");
        }
        if (this._readBuffer != null) {
            if (this._readBuffer == existingReadBuffer) {
                throw new IOException("Invalid Call to putBack - Trying to put back current read buffer!");
            }
            if (this._readBuffer == this._writeBuffer) {
                throw new RuntimeException("Critical Error!! read and write buffer pointers identical !!!");
            }
            this._bufferListBytes += this._readBuffer.remaining();
            this._bufferList.addFirst(this._readBuffer);
        }
        this._readBuffer = existingReadBuffer;
        if (this._readBuffer == this._writeBuffer) {
            throw new RuntimeException("Critical Error!! read and write buffer pointers identical !!!");
        }
    }

    public ByteBuffer read(int desiredMinSize) throws IOException {
        ByteBuffer nextBuffer;
        int shortBy;
        ByteBuffer bufferOut = this.read();
        if (bufferOut != null && (shortBy = Math.max(0, desiredMinSize - bufferOut.remaining())) != 0 && (nextBuffer = this._getNextReadBuf()) != null) {
            bufferOut.compact();
            if (bufferOut.capacity() - bufferOut.limit() >= shortBy && nextBuffer.remaining() >= shortBy) {
                int originalLimit;
                int newLimit = originalLimit + shortBy;
                bufferOut.limit(newLimit);
                for (originalLimit = bufferOut.limit(); originalLimit < newLimit; ++originalLimit) {
                    bufferOut.put(originalLimit, nextBuffer.get());
                }
            }
        }
        return bufferOut;
    }

    public synchronized ByteBuffer read() throws IOException {
        this._getNextReadBuf();
        ByteBuffer bufferOut = this._readBuffer;
        this._readBuffer = null;
        return bufferOut;
    }

    public synchronized ByteBuffer peekAtWriteBuffer() {
        return this._writeBuffer;
    }

    public synchronized void write(ByteBuffer buffer) throws IOException {
        if (this._writeBuffer != buffer) {
            this.flush();
        }
        this._writeBuffer = buffer;
    }

    public void write(int value) throws IOException {
        ByteBuffer writeBuffer = this.getWriteBuf();
        writeBuffer.put((byte)value);
    }

    public void write(byte[] buffer, int offset, int size) throws IOException {
        while (size > 0) {
            ByteBuffer writeBuffer = this.getWriteBuf();
            int available = Math.min(writeBuffer.remaining(), size);
            writeBuffer.put(buffer, offset, available);
            offset += available;
            size -= available;
        }
    }

    private synchronized ByteBuffer _getNextReadBuf() throws IOException {
        while (this._readBuffer == null || !this._readBuffer.hasRemaining()) {
            this._readBuffer = null;
            if (!this._bufferList.isEmpty()) {
                this._readBuffer = this._bufferList.removeFirst();
                this._bufferListBytes -= this._readBuffer.remaining();
            }
            if (this._readBuffer != null) continue;
        }
        if (this._readBuffer != null && this._readEvent != null) {
            this._readLock.lock();
            this._readEvent.signal();
            this._readEvent = null;
            this._readLock.unlock();
        }
        return this._readBuffer;
    }

    public final ByteBuffer allocateBuffer() throws IOException {
        int desiredAllocSize = Math.max(this._minBufferSize, Math.min(this._maxBufferSize, this._lastWriteBufSize << 1));
        return ByteBuffer.allocate(desiredAllocSize);
    }

    public synchronized ByteBuffer getWriteBuf() throws IOException {
        if (this._writeBuffer == null || !this._writeBuffer.hasRemaining()) {
            this.flush();
            this._writeBuffer = this.allocateBuffer();
        }
        return this._writeBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        NIODataSink sink = null;
        ByteBuffer lastWriteBuffer = null;
        NIOBufferList nIOBufferList = this;
        synchronized (nIOBufferList) {
            if (this._writeBuffer != null && this._writeBuffer.position() != 0) {
                this._lastWriteBufSize = Math.max(this._minBufferSize, this._writeBuffer.position());
                this._writeBuffer.flip();
                if (this._readBuffer == this._writeBuffer) {
                    throw new RuntimeException("read and write buffer pointers identical !!!");
                }
                sink = this.getSink();
                if (sink != null) {
                    lastWriteBuffer = this._writeBuffer;
                } else {
                    this._bufferListBytes += this._writeBuffer.remaining();
                    this._bufferList.add(this._writeBuffer);
                }
                this._writeBuffer = null;
            }
        }
        if (sink != null && lastWriteBuffer != null) {
            this.getSink().available(lastWriteBuffer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CRLFReadState {
        NONE,
        GOT_CR,
        DONE;

    }
}

