/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.mergeutils;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.commoncrawl.util.shared.FlexBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptimizedKeyGeneratorAndComparator<KeyType extends Writable, ValueType extends Writable> {
    public abstract int getGeneratedKeyType();

    public abstract void generateOptimizedKeyForPair(KeyType var1, ValueType var2, OptimizedKey var3) throws IOException;

    public long generateOptimizedKeyForRawPair(byte[] keyData, int keyOffset, int keyLength, byte[] valueData, int valueOffset, int valueLength, OptimizedKey optimizedKeyOut) throws IOException {
        throw new IOException("generate OptimizedKeyForRawPair not implemented in base class!");
    }

    public int compareOptimizedBufferKeys(byte[] key1Data, int key1Offset, int key1Length, byte[] key2Data, int key2Offset, int key2Length) throws IOException {
        throw new IOException("compare optimized buffers not implemented in base class!");
    }

    public static final class OptimizedKey {
        public static final int KEY_TYPE_LONG = 1;
        public static final int KEY_TYPE_BUFFER = 2;
        public static final int KEY_TYPE_LONG_AND_BUFFER = 3;
        private int _keyType;
        private int _headerSize = 0;
        private long _longKeyValue = 0L;
        private int _dataBufferSize = 0;
        private int _dataBufferOffset = 0;
        private FlexBuffer _dataBuffer = new FlexBuffer();
        private DataOutputBuffer _outputStream = new DataOutputBuffer(){

            public void close() throws IOException {
                super.close();
                OptimizedKey.this._dataBuffer.set(this.getData(), 0, this.getLength(), true);
                OptimizedKey.this._dataBufferSize = this.getLength();
            }
        };
        private DataInputBuffer _inputStream = new DataInputBuffer();

        public OptimizedKey(int keyType) {
            this._keyType = keyType;
            this._headerSize = 0;
            if ((this._keyType & 1) != 0) {
                this._headerSize += 8;
            }
            if ((this._keyType & 2) != 0) {
                this._headerSize += 8;
            }
        }

        public int getKeyType() {
            return this._keyType;
        }

        public int getHeaderSize() {
            return this._headerSize;
        }

        public int getDataBufferSize() {
            return this._dataBufferSize;
        }

        public int getDataBufferOffset() {
            return this._dataBufferOffset;
        }

        public void setDataBufferOffset(int dataBufferOffset) {
            this._dataBufferOffset = dataBufferOffset;
        }

        public int writeHeaderToStream(DataOutputStream outputStream) throws IOException {
            if ((this._keyType & 1) != 0) {
                outputStream.writeLong(this._longKeyValue);
            }
            if ((this._keyType & 2) != 0) {
                outputStream.writeInt(this._dataBuffer.getCount());
                outputStream.writeInt(this._dataBufferOffset);
            }
            return this._headerSize;
        }

        public int writeBufferToStream(DataOutputStream outputStream) throws IOException {
            this._dataBufferSize = 0;
            if ((this._keyType & 2) != 0) {
                outputStream.write(this._dataBuffer.get(), this._dataBuffer.getOffset(), this._dataBuffer.getCount());
                this._dataBufferSize += this._dataBuffer.getCount();
            }
            return this._dataBufferSize;
        }

        public DataOutputStream getBufferKeyValueStream() throws IOException {
            this._outputStream.reset();
            return this._outputStream;
        }

        public long getLongKeyValue() {
            return this._longKeyValue;
        }

        public void setLongKeyValue(long value) {
            this._longKeyValue = value;
        }

        public FlexBuffer getBufferKeyValue() {
            return this._dataBuffer;
        }

        public int readHeader(DataInputStream stream) throws IOException {
            if ((this._keyType & 1) != 0) {
                this._longKeyValue = stream.readLong();
            }
            if ((this._keyType & 2) != 0) {
                this._dataBufferSize = stream.readInt();
                this._dataBufferOffset = stream.readInt();
            }
            return this._headerSize;
        }

        public int initFromKeyValuePair(byte[] keyBytes, int keyOffset, int keyLength, byte[] valueBytes, int valueOffset, int valueLength) throws IOException {
            this._inputStream.reset(keyBytes, keyOffset, keyLength);
            this.readHeader((DataInputStream)this._inputStream);
            if ((this._keyType & 2) != 0 && this._dataBufferSize != 0) {
                this._dataBuffer.set(valueBytes, valueOffset + valueLength - this._dataBufferSize, this._dataBufferSize, true);
            }
            return this._dataBufferSize;
        }

        public static int writeVLong(DataOutput stream, long i) throws IOException {
            int bytesUsed = 1;
            if (i >= -112L && i <= 127L) {
                stream.writeByte((byte)i);
                return bytesUsed;
            }
            int len = -112;
            if (i < 0L) {
                i ^= 0xFFFFFFFFFFFFFFFFL;
                len = -120;
            }
            long tmp = i;
            while (tmp != 0L) {
                tmp >>= 8;
                --len;
            }
            stream.writeByte((byte)len);
            ++bytesUsed;
            for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
                int shiftbits = (idx - 1) * 8;
                long mask = 255L << shiftbits;
                stream.writeByte((byte)((i & mask) >> shiftbits));
                ++bytesUsed;
            }
            return bytesUsed;
        }
    }
}

