/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.mergeutils;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.Reporter;
import org.commoncrawl.hadoop.mergeutils.OptimizedKeyGeneratorAndComparator;
import org.commoncrawl.hadoop.mergeutils.RawDataSpillWriter;
import org.commoncrawl.hadoop.mergeutils.RawKeyValueComparator;
import org.commoncrawl.hadoop.mergeutils.SequenceFileMerger;
import org.commoncrawl.hadoop.mergeutils.SequenceFileSpillWriter;
import org.commoncrawl.hadoop.mergeutils.SpillValueCombiner;
import org.commoncrawl.hadoop.mergeutils.SpillWriter;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSortSpillWriter<KeyType extends WritableComparable, ValueType extends Writable>
implements SpillWriter<KeyType, ValueType> {
    public static final Log LOG = LogFactory.getLog(MergeSortSpillWriter.class);
    private static int DEFAULT_SPILL_INDEX_BUFFER_SIZE = 1000000;
    private static int SPILL_DATA_ITEM_AVG_SIZE = 400;
    private static int DEFAULT_SPILL_DATA_BUFFER_SIZE = DEFAULT_SPILL_INDEX_BUFFER_SIZE * SPILL_DATA_ITEM_AVG_SIZE;
    private static int DEFAULT_REPLICATION_FACTOR = 2;
    public static final String SPILL_INDEX_BUFFER_SIZE_PARAM = "commoncrawl.spill.indexbuffer.size";
    public static final String SPILL_DATA_BUFFER_SIZE_PARAM = "commoncrawl.spill.databuffer.size";
    public static final String SPILL_FILE_REPLICATION_FACTOR_PARAM = "commoncrawl.spill.replication.factor";
    FileSystem _tempDataFileSystem;
    Configuration _conf;
    int[] _spillIndexBuffer;
    ByteBuffer _spillDataBuffer;
    byte[] _spillDataBufferBytes;
    int _spillItemCount = 0;
    private NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    Vector<Path> _mergeSegements = new Vector();
    RawKeyValueComparator<KeyType, ValueType> _comparator = null;
    OptimizedKeyGeneratorAndComparator<KeyType, ValueType> _optimizedKeyGenerator = null;
    OptimizedKeyGeneratorAndComparator.OptimizedKey _optimizedKey = null;
    SpillValueCombiner<KeyType, ValueType> _optCombiner = null;
    RawDataSpillWriter<KeyType, ValueType> _outputSpillWriter = null;
    Path _temporaryDirectoryPath;
    Class<KeyType> _keyClass;
    Class<ValueType> _valueClass;
    DataOutputStream _outputStream;
    DataInputStream _inputStream;
    CompressionCodec _compressionCodec;
    Reporter _reporter;
    int _spillIndexBufferSize = -1;
    int _spillDataBufferSize = -1;
    DataInputBuffer _reader1 = new DataInputBuffer();
    DataInputBuffer _reader2 = new DataInputBuffer();

    public MergeSortSpillWriter(Configuration conf, RawDataSpillWriter<KeyType, ValueType> outputSpillWriter, FileSystem tempDataFileSystem, Path tempDirectoryPath, SpillValueCombiner<KeyType, ValueType> optionalCombiner, RawKeyValueComparator<KeyType, ValueType> comparator, Class<KeyType> keyClass, Class<ValueType> valueClass, CompressionCodec compressionCodec, Reporter reporter) throws IOException {
        this.init(conf, outputSpillWriter, tempDataFileSystem, tempDirectoryPath, comparator, null, optionalCombiner, keyClass, valueClass, compressionCodec, reporter);
    }

    public MergeSortSpillWriter(Configuration conf, RawDataSpillWriter<KeyType, ValueType> outputSpillWriter, FileSystem tempDataFileSystem, Path tempDirectoryPath, OptimizedKeyGeneratorAndComparator<KeyType, ValueType> keyGenerator, Class<KeyType> keyClass, Class<ValueType> valueClass, CompressionCodec compressionCodec, Reporter reporter) throws IOException {
        this.init(conf, outputSpillWriter, tempDataFileSystem, tempDirectoryPath, null, keyGenerator, null, keyClass, valueClass, compressionCodec, reporter);
    }

    private void init(Configuration conf, RawDataSpillWriter<KeyType, ValueType> outputSpillWriter, FileSystem tempDataFileSystem, Path tempDirectoryPath, RawKeyValueComparator<KeyType, ValueType> comparator, OptimizedKeyGeneratorAndComparator<KeyType, ValueType> optionalGenerator, SpillValueCombiner<KeyType, ValueType> optCombiner, Class<KeyType> keyClass, Class<ValueType> valueClass, CompressionCodec compressionCodec, Reporter reporter) throws IOException {
        this._tempDataFileSystem = tempDataFileSystem;
        this._conf = conf;
        this._comparator = comparator;
        this._optimizedKeyGenerator = optionalGenerator;
        if (this._optimizedKeyGenerator != null) {
            this._optimizedKey = new OptimizedKeyGeneratorAndComparator.OptimizedKey(this._optimizedKeyGenerator.getGeneratedKeyType());
        }
        this._optCombiner = optCombiner;
        this._outputSpillWriter = outputSpillWriter;
        this._keyClass = keyClass;
        this._valueClass = valueClass;
        this._temporaryDirectoryPath = new Path(tempDirectoryPath, Long.toString(Thread.currentThread().getId()) + "-" + System.currentTimeMillis());
        this._tempDataFileSystem.delete(this._temporaryDirectoryPath, true);
        this._tempDataFileSystem.mkdirs(this._temporaryDirectoryPath);
        this.NUMBER_FORMAT.setMinimumIntegerDigits(5);
        this.NUMBER_FORMAT.setGroupingUsed(false);
        this._compressionCodec = compressionCodec;
        this._reporter = reporter;
        this._spillIndexBufferSize = this._conf.getInt(SPILL_INDEX_BUFFER_SIZE_PARAM, DEFAULT_SPILL_INDEX_BUFFER_SIZE);
        LOG.info((Object)("SpillIndexBufferSize:" + this._spillIndexBufferSize));
        this._spillDataBufferSize = this._conf.getInt(SPILL_DATA_BUFFER_SIZE_PARAM, DEFAULT_SPILL_DATA_BUFFER_SIZE);
        LOG.info((Object)("SpillDataBufferSize:" + this._spillDataBufferSize));
        this._spillIndexBuffer = new int[this._spillIndexBufferSize];
        this._spillDataBuffer = ByteBuffer.allocate(this._spillDataBufferSize);
        this._spillDataBufferBytes = this._spillDataBuffer.array();
        this._spillDataBuffer.clear();
        this._outputStream = new DataOutputStream(MergeSortSpillWriter.newOutputStream(this._spillDataBuffer));
        this._inputStream = new DataInputStream(MergeSortSpillWriter.newInputStream(this._spillDataBuffer));
    }

    private void freeMemory() {
        this._spillDataBuffer = null;
        this._spillIndexBuffer = null;
    }

    /*
     * Loose catch block
     */
    @Override
    public void close() throws IOException {
        block18: {
            LOG.info((Object)"Entering flushAndClose");
            if (this._spillItemCount == 0 && this._mergeSegements.size() == 0) {
                LOG.info((Object)"No Data to Merge. Exiting Prematurely");
                this.freeMemory();
                return;
            }
            if (this._spillItemCount != 0) {
                LOG.info((Object)("Trailing Spill Data Items of Count:" + this._spillItemCount));
                if (this._mergeSegements.size() == 0) {
                    LOG.info((Object)"Merge Segment Count is zero. Sorting and Spilling to output file directly");
                    this.sortAndSpill(this._outputSpillWriter);
                    this.freeMemory();
                    return;
                }
                LOG.info((Object)"Merge Segment Count non-zero. Sorting and Spilling to temporary file");
                this.sortAndSpill(null);
                this._spillItemCount = 0;
            }
            if (this._mergeSegements.size() != 0) {
                Object v0;
                if (this._mergeSegements.size() == 1) {
                    throw new IOException("Improper merge segment count. Expected >1 got 1");
                }
                LOG.info((Object)("Merging " + this._mergeSegements.size() + " Segments"));
                SequenceFileMerger<KeyType, ValueType> merger = null;
                merger = this._optimizedKeyGenerator != null ? new SequenceFileMerger<KeyType, ValueType>(this._tempDataFileSystem, this._conf, this._mergeSegements, this._outputSpillWriter, this._keyClass, this._valueClass, this._optimizedKeyGenerator) : new SequenceFileMerger<KeyType, ValueType>(this._tempDataFileSystem, this._conf, this._mergeSegements, this._outputSpillWriter, this._keyClass, this._valueClass, this._optCombiner, this._comparator);
                long mergeStartTime = System.currentTimeMillis();
                LOG.info((Object)"Starting Final Merge");
                merger.mergeAndSpill(this._reporter);
                long mergeEndTime = System.currentTimeMillis();
                LOG.info((Object)("Final Merge took:" + (mergeEndTime - mergeStartTime)));
                Object var7_5 = null;
                try {
                    try {
                        merger.close();
                        v0 = null;
                    }
                    catch (IOException e) {
                        LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    v0 = null;
                }
                Object var10_11 = v0;
                LOG.info((Object)"Deleting temporary files");
                for (Path path : this._mergeSegements) {
                    FileUtils.recursivelyDeleteFile(new File(path.toString()));
                }
                this._tempDataFileSystem.delete(this._temporaryDirectoryPath, true);
                this._mergeSegements.clear();
                {
                    break block18;
                    catch (IOException e) {
                        LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object v1;
                    Object var7_6 = null;
                    try {
                        try {
                            merger.close();
                            v1 = null;
                        }
                        catch (IOException e) {
                            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                            throw e;
                        }
                    }
                    catch (Throwable throwable2) {
                        v1 = null;
                    }
                    Object var10_12 = v1;
                    LOG.info((Object)"Deleting temporary files");
                    for (Path path : this._mergeSegements) {
                        FileUtils.recursivelyDeleteFile(new File(path.toString()));
                    }
                    this._tempDataFileSystem.delete(this._temporaryDirectoryPath, true);
                    this._mergeSegements.clear();
                    throw throwable;
                }
            }
        }
    }

    private Path getNextSpillFilePath() {
        return new Path(this._temporaryDirectoryPath, "part-" + this.NUMBER_FORMAT.format(this._mergeSegements.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sortAndSpill(RawDataSpillWriter<KeyType, ValueType> optionalWriter) throws IOException {
        long spillTimeStart;
        RawDataSpillWriter<KeyType, ValueType> spillWriter;
        Path spillFilePath;
        long sortAndSpillTime;
        block19: {
            long sortTimeStart;
            byte[] bufferAsBytes;
            block18: {
                block20: {
                    bufferAsBytes = this._spillDataBuffer.array();
                    sortAndSpillTime = System.currentTimeMillis();
                    sortTimeStart = System.currentTimeMillis();
                    if (this._optimizedKeyGenerator == null) break block20;
                    if (this._optimizedKey.getKeyType() == 1) {
                        LOG.info((Object)("Sorting:" + this._spillItemCount + " Items Using Optimized Long Comparator"));
                        this.sortUsingOptimizedLongComparator(this._spillIndexBuffer, 0, this._spillItemCount);
                        break block18;
                    } else if (this._optimizedKey.getKeyType() == 2) {
                        LOG.info((Object)("Sorting:" + this._spillItemCount + " Items Using Optimized Buffer Comparator"));
                        this.sortUsingOptimizedBufferKeys(bufferAsBytes, this._spillIndexBuffer, 0, this._spillItemCount);
                        break block18;
                    } else {
                        if (this._optimizedKey.getKeyType() != 3) {
                            throw new IOException("Unknown Optimized Key Type!");
                        }
                        LOG.info((Object)("Sorting:" + this._spillItemCount + " Items Using Optimized Long And Buffer Only Comparator"));
                        this.sortUsingOptimizedLongAndBufferKeys(bufferAsBytes, this._spillIndexBuffer, 0, this._spillItemCount);
                    }
                    break block18;
                }
                LOG.info((Object)("Sorting:" + this._spillItemCount + " Items Using Raw Comparator"));
                this.sortUsingRawComparator(bufferAsBytes, this._spillIndexBuffer, 0, this._spillItemCount);
            }
            LOG.info((Object)("Sort Took:" + (System.currentTimeMillis() - sortTimeStart)));
            spillFilePath = this.getNextSpillFilePath();
            spillWriter = null;
            boolean directSpillOutput = false;
            if (optionalWriter != null) {
                LOG.info((Object)"Writing spill output directory to final spill writer");
                spillWriter = optionalWriter;
                directSpillOutput = true;
            } else {
                LOG.info((Object)("Writing spill output to temporary spill file:" + spillFilePath));
                spillWriter = new SequenceFileSpillWriter<KeyType, ValueType>(this._tempDataFileSystem, this._conf, spillFilePath, this._keyClass, this._valueClass, null, this._compressionCodec, (short)this._conf.getInt(SPILL_FILE_REPLICATION_FACTOR_PARAM, DEFAULT_REPLICATION_FACTOR));
            }
            spillTimeStart = System.currentTimeMillis();
            try {
                int i = 0;
                int dataOffset = 0;
                int keyLen = 0;
                int keyPos = 0;
                int valueLen = 0;
                int valuePosition = 0;
                int optimizedBufferLen = 0;
                for (i = 0; i < this._spillItemCount; ++i) {
                    try {
                        dataOffset = this._spillIndexBuffer[i];
                        this._spillDataBuffer.position(dataOffset);
                        if (this._optimizedKeyGenerator != null) {
                            this._optimizedKey.readHeader(this._inputStream);
                            optimizedBufferLen = this._optimizedKey.getDataBufferSize();
                        } else {
                            optimizedBufferLen = 0;
                        }
                        keyLen = this._spillDataBuffer.getInt();
                        keyPos = this._spillDataBuffer.position();
                        this._spillDataBuffer.position(keyPos + keyLen);
                        valueLen = this._spillDataBuffer.getInt();
                        valuePosition = this._spillDataBuffer.position();
                        this._spillDataBuffer.position(valuePosition + valueLen + optimizedBufferLen);
                        if (directSpillOutput || this._optimizedKeyGenerator == null) {
                            spillWriter.spillRawRecord(bufferAsBytes, keyPos, keyLen, bufferAsBytes, valuePosition, valueLen);
                        } else {
                            spillWriter.spillRawRecord(bufferAsBytes, dataOffset, keyLen + this._optimizedKey.getHeaderSize() + 4, bufferAsBytes, valuePosition, valueLen + optimizedBufferLen);
                        }
                        if (i % 100000 != 0) continue;
                        LOG.info((Object)("Spilled " + i + " Records"));
                        if (this._reporter == null) continue;
                        this._reporter.progress();
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error in Iteration.  DataOffset:" + dataOffset + " index:" + i + " keyLen:" + keyLen + " keyPos:" + keyPos + " valueLen:" + valueLen + " valuePos:" + valuePosition + " spillDataBufferSize:" + this._spillDataBuffer.capacity() + " spillDataPosition:" + this._spillDataBuffer.position() + " spillDataRemaining:" + this._spillDataBuffer.remaining()));
                        CCStringUtils.stringifyException((Throwable)e);
                        throw new IOException(e);
                    }
                }
                Object var21_17 = null;
                if (spillWriter == optionalWriter) break block19;
            }
            catch (Throwable throwable) {
                Object var21_18 = null;
                if (spillWriter != optionalWriter) {
                    spillWriter.close();
                }
                throw throwable;
            }
            spillWriter.close();
        }
        LOG.info((Object)("Spill Took:" + (System.currentTimeMillis() - spillTimeStart)));
        if (spillWriter != optionalWriter) {
            this._mergeSegements.add(spillFilePath);
        }
        LOG.info((Object)("Spill and Sort for:" + this._spillItemCount + " Took:" + (System.currentTimeMillis() - sortAndSpillTime)));
        this._spillDataBuffer.position(0);
        this._spillItemCount = 0;
    }

    static final int getIntB(byte[] bb, int offset) {
        return (bb[offset + 0] & 0xFF) << 24 | (bb[offset + 1] & 0xFF) << 16 | (bb[offset + 2] & 0xFF) << 8 | (bb[offset + 3] & 0xFF) << 0;
    }

    private static final int compareUsingRawComparator(RawKeyValueComparator comparator, byte[] keyValueData1, int offset1, byte[] keyValueData2, int offset2) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(keyValueData1);
        int testKey1Length = buffer.getInt();
        int key1Length = MergeSortSpillWriter.getIntB(keyValueData1, offset1);
        int key1Offset = offset1 + 4;
        int value1Offset = key1Offset + key1Length + 4;
        int value1Length = MergeSortSpillWriter.getIntB(keyValueData1, key1Offset + key1Length);
        int key2Length = MergeSortSpillWriter.getIntB(keyValueData2, offset2);
        int key2Offset = offset2 + 4;
        int value2Offset = key2Offset + key2Length + 4;
        int value2Length = MergeSortSpillWriter.getIntB(keyValueData2, key2Offset + key2Length);
        return comparator.compareRaw(keyValueData1, key1Offset, key1Length, keyValueData2, key2Offset, key2Length, keyValueData1, value1Offset, value1Length, keyValueData2, value2Offset, value2Length);
    }

    private final int med3UsingOptimizedComparatorWithLongs(int[] x, int a, int b, int c) throws IOException {
        long aValue = this._spillDataBuffer.getLong(x[a]);
        long bValue = this._spillDataBuffer.getLong(x[b]);
        long cValue = this._spillDataBuffer.getLong(x[c]);
        return aValue < bValue ? (bValue < cValue ? b : (aValue < cValue ? c : a)) : (bValue > cValue ? b : (aValue > cValue ? c : a));
    }

    private final int med3UsingRawComparator(byte[] spillData, int[] x, int a, int b, int c) throws IOException {
        return MergeSortSpillWriter.compareUsingRawComparator(this._comparator, spillData, x[a], spillData, x[b]) < 0 ? (MergeSortSpillWriter.compareUsingRawComparator(this._comparator, spillData, x[b], spillData, x[c]) < 0 ? b : (MergeSortSpillWriter.compareUsingRawComparator(this._comparator, spillData, x[a], spillData, x[c]) < 0 ? c : a)) : (MergeSortSpillWriter.compareUsingRawComparator(this._comparator, spillData, x[b], spillData, x[c]) > 0 ? b : (MergeSortSpillWriter.compareUsingRawComparator(this._comparator, spillData, x[a], spillData, x[c]) > 0 ? c : a));
    }

    private final int med3UsingOptimizedComparatorWithLongsAndBuffer(byte[] spillData, int[] x, int a, int b, int c) throws IOException {
        return this.compareUsingOptimizedRawLongAndBufferValues(spillData, x[a], x[b]) < 0 ? (this.compareUsingOptimizedRawLongAndBufferValues(spillData, x[b], x[c]) < 0 ? b : (this.compareUsingOptimizedRawLongAndBufferValues(spillData, x[a], x[c]) < 0 ? c : a)) : (this.compareUsingOptimizedRawLongAndBufferValues(spillData, x[b], x[c]) > 0 ? b : (this.compareUsingOptimizedRawLongAndBufferValues(spillData, x[a], x[c]) > 0 ? c : a));
    }

    private final int med3UsingOptimizedComparatorWithBuffer(byte[] spillData, int[] x, int a, int b, int c) throws IOException {
        return this.compareUsingOptimizedRawBufferValues(spillData, x[a], x[b]) < 0 ? (this.compareUsingOptimizedRawBufferValues(spillData, x[b], x[c]) < 0 ? b : (this.compareUsingOptimizedRawBufferValues(spillData, x[a], x[c]) < 0 ? c : a)) : (this.compareUsingOptimizedRawBufferValues(spillData, x[b], x[c]) > 0 ? b : (this.compareUsingOptimizedRawBufferValues(spillData, x[a], x[c]) > 0 ? c : a));
    }

    private void sortUsingRawComparator(byte[] dataBytes, int[] x, int off, int len) throws IOException {
        int c;
        int a;
        byte[] spillData = this._spillDataBuffer.array();
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && MergeSortSpillWriter.compareUsingRawComparator(this._comparator, spillData, x[j - 1], spillData, x[j]) > 0; --j) {
                    MergeSortSpillWriter.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3UsingRawComparator(dataBytes, x, l, l + s, l + 2 * s);
                m = this.med3UsingRawComparator(dataBytes, x, m - s, m, m + s);
                n = this.med3UsingRawComparator(dataBytes, x, n - 2 * s, n - s, n);
            }
            m = this.med3UsingRawComparator(dataBytes, x, l, m, n);
        }
        int vOffset = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && MergeSortSpillWriter.compareUsingRawComparator(this._comparator, spillData, x[b], spillData, vOffset) <= 0) {
                if (MergeSortSpillWriter.compareUsingRawComparator(this._comparator, spillData, x[b], spillData, vOffset) == 0) {
                    MergeSortSpillWriter.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && MergeSortSpillWriter.compareUsingRawComparator(this._comparator, spillData, x[c], spillData, vOffset) >= 0) {
                if (MergeSortSpillWriter.compareUsingRawComparator(this._comparator, spillData, x[c], spillData, vOffset) == 0) {
                    MergeSortSpillWriter.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            MergeSortSpillWriter.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sortUsingRawComparator(dataBytes, x, off, s);
        }
        if ((s = d - c) > 1) {
            this.sortUsingRawComparator(dataBytes, x, n - s, s);
        }
    }

    private void sortUsingOptimizedLongComparator(int[] x, int off, int len) throws IOException {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this._spillDataBuffer.getLong(x[j - 1]) > this._spillDataBuffer.getLong(x[j]); --j) {
                    MergeSortSpillWriter.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3UsingOptimizedComparatorWithLongs(x, l, l + s, l + 2 * s);
                m = this.med3UsingOptimizedComparatorWithLongs(x, m - s, m, m + s);
                n = this.med3UsingOptimizedComparatorWithLongs(x, n - 2 * s, n - s, n);
            }
            m = this.med3UsingOptimizedComparatorWithLongs(x, l, m, n);
        }
        long v = this._spillDataBuffer.getLong(x[m]);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this._spillDataBuffer.getLong(x[b]) <= v) {
                if (this._spillDataBuffer.getLong(x[b]) == v) {
                    MergeSortSpillWriter.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this._spillDataBuffer.getLong(x[c]) >= v) {
                if (this._spillDataBuffer.getLong(x[c]) == v) {
                    MergeSortSpillWriter.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            MergeSortSpillWriter.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sortUsingOptimizedLongComparator(x, off, s);
        }
        if ((s = d - c) > 1) {
            this.sortUsingOptimizedLongComparator(x, n - s, s);
        }
    }

    private final int compareUsingOptimizedRawLongAndBufferValues(byte[] dataAsBytes, int lValueDataOffset, int rValueDataOffset) throws IOException {
        int result;
        long lValue = this._spillDataBuffer.getLong(lValueDataOffset);
        long rValue = this._spillDataBuffer.getLong(rValueDataOffset);
        int buffer1Len = this._spillDataBuffer.getInt(lValueDataOffset + 8);
        int buffer2Len = this._spillDataBuffer.getInt(rValueDataOffset + 8);
        int buffer1Offset = this._spillDataBuffer.getInt(lValueDataOffset + 12);
        int buffer2Offset = this._spillDataBuffer.getInt(rValueDataOffset + 12);
        int n = lValue > rValue ? 1 : (result = lValue < rValue ? -1 : 0);
        if (result == 0) {
            return this._optimizedKeyGenerator.compareOptimizedBufferKeys(dataAsBytes, lValueDataOffset + buffer1Offset, buffer1Len, dataAsBytes, rValueDataOffset + buffer2Offset, buffer2Len);
        }
        return result;
    }

    private final int compareUsingOptimizedRawBufferValues(byte[] dataAsBytes, int lValueDataOffset, int rValueDataOffset) throws IOException {
        int buffer1Len = this._spillDataBuffer.getInt(lValueDataOffset);
        int buffer2Len = this._spillDataBuffer.getInt(rValueDataOffset);
        int buffer1Offset = this._spillDataBuffer.getInt(lValueDataOffset + 4);
        int buffer2Offset = this._spillDataBuffer.getInt(rValueDataOffset + 4);
        return this._optimizedKeyGenerator.compareOptimizedBufferKeys(dataAsBytes, lValueDataOffset + buffer1Offset, buffer1Len, dataAsBytes, rValueDataOffset + buffer2Offset, buffer2Len);
    }

    private void sortUsingOptimizedLongAndBufferKeys(byte[] dataBytes, int[] x, int off, int len) throws IOException {
        int c;
        int a;
        byte[] spillData = this._spillDataBuffer.array();
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.compareUsingOptimizedRawLongAndBufferValues(spillData, x[j - 1], x[j]) > 0; --j) {
                    MergeSortSpillWriter.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3UsingOptimizedComparatorWithLongsAndBuffer(dataBytes, x, l, l + s, l + 2 * s);
                m = this.med3UsingOptimizedComparatorWithLongsAndBuffer(dataBytes, x, m - s, m, m + s);
                n = this.med3UsingOptimizedComparatorWithLongsAndBuffer(dataBytes, x, n - 2 * s, n - s, n);
            }
            m = this.med3UsingOptimizedComparatorWithLongsAndBuffer(dataBytes, x, l, m, n);
        }
        int vOffset = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.compareUsingOptimizedRawLongAndBufferValues(spillData, x[b], vOffset) <= 0) {
                if (this.compareUsingOptimizedRawLongAndBufferValues(spillData, x[b], vOffset) == 0) {
                    MergeSortSpillWriter.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.compareUsingOptimizedRawLongAndBufferValues(spillData, x[c], vOffset) >= 0) {
                if (this.compareUsingOptimizedRawLongAndBufferValues(spillData, x[c], vOffset) == 0) {
                    MergeSortSpillWriter.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            MergeSortSpillWriter.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sortUsingOptimizedLongAndBufferKeys(dataBytes, x, off, s);
        }
        if ((s = d - c) > 1) {
            this.sortUsingOptimizedLongAndBufferKeys(dataBytes, x, n - s, s);
        }
    }

    private void sortUsingOptimizedBufferKeys(byte[] dataBytes, int[] x, int off, int len) throws IOException {
        int c;
        int a;
        byte[] spillData = this._spillDataBuffer.array();
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.compareUsingOptimizedRawBufferValues(spillData, x[j - 1], x[j]) > 0; --j) {
                    MergeSortSpillWriter.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3UsingOptimizedComparatorWithBuffer(dataBytes, x, l, l + s, l + 2 * s);
                m = this.med3UsingOptimizedComparatorWithBuffer(dataBytes, x, m - s, m, m + s);
                n = this.med3UsingOptimizedComparatorWithBuffer(dataBytes, x, n - 2 * s, n - s, n);
            }
            m = this.med3UsingOptimizedComparatorWithBuffer(dataBytes, x, l, m, n);
        }
        int vOffset = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.compareUsingOptimizedRawBufferValues(spillData, x[b], vOffset) <= 0) {
                if (this.compareUsingOptimizedRawBufferValues(spillData, x[b], vOffset) == 0) {
                    MergeSortSpillWriter.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.compareUsingOptimizedRawBufferValues(spillData, x[c], vOffset) >= 0) {
                if (this.compareUsingOptimizedRawBufferValues(spillData, x[c], vOffset) == 0) {
                    MergeSortSpillWriter.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            MergeSortSpillWriter.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sortUsingOptimizedBufferKeys(dataBytes, x, off, s);
        }
        if ((s = d - c) > 1) {
            this.sortUsingOptimizedBufferKeys(dataBytes, x, n - s, s);
        }
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            MergeSortSpillWriter.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @Override
    public void spillRecord(KeyType key, ValueType value) throws IOException {
        if (this._spillItemCount == this._spillIndexBufferSize) {
            this.sortAndSpill(null);
        }
        boolean done = false;
        while (!done) {
            int startPositon = this._spillDataBuffer.position();
            boolean overflow = false;
            try {
                if (this._optimizedKeyGenerator != null) {
                    this._optimizedKeyGenerator.generateOptimizedKeyForPair(key, value, this._optimizedKey);
                    this._spillDataBuffer.position(this._spillDataBuffer.position() + this._optimizedKey.getHeaderSize());
                }
                int keySizePos = this._spillDataBuffer.position();
                this._spillDataBuffer.position(keySizePos + 4);
                key.write((DataOutput)this._outputStream);
                int valueSizePos = this._spillDataBuffer.position();
                int keySize = valueSizePos - keySizePos - 4;
                this._spillDataBuffer.position(keySizePos);
                this._spillDataBuffer.putInt(keySize);
                this._spillDataBuffer.position(valueSizePos + 4);
                value.write((DataOutput)this._outputStream);
                int endPosition = this._spillDataBuffer.position();
                int valueSize = endPosition - valueSizePos - 4;
                this._spillDataBuffer.position(valueSizePos);
                this._spillDataBuffer.putInt(valueSize);
                this._spillDataBuffer.position(endPosition);
                if (this._optimizedKeyGenerator != null) {
                    if (this._optimizedKey.getDataBufferSize() != 0) {
                        this._optimizedKey.setDataBufferOffset(this._spillDataBuffer.position() - startPositon);
                        this._optimizedKey.writeBufferToStream(this._outputStream);
                    }
                    int nextItemPosition = this._spillDataBuffer.position();
                    this._spillDataBuffer.position(startPositon);
                    this._optimizedKey.writeHeaderToStream(this._outputStream);
                    this._spillDataBuffer.position(nextItemPosition);
                }
                this._spillIndexBuffer[this._spillItemCount] = startPositon;
                ++this._spillItemCount;
                done = true;
            }
            catch (IllegalArgumentException e) {
                overflow = true;
            }
            catch (BufferOverflowException e) {
                overflow = true;
            }
            if (!overflow) continue;
            this._spillDataBuffer.position(startPositon);
            this.sortAndSpill(null);
        }
    }

    private static OutputStream newOutputStream(final ByteBuffer buf) {
        return new OutputStream(){

            public void write(int b) throws IOException {
                buf.put((byte)(b & 0xFF));
            }

            public void write(byte[] src, int off, int len) throws IOException {
                buf.put(src, off, len);
            }
        };
    }

    public static InputStream newInputStream(final ByteBuffer buf) {
        return new InputStream(){

            public synchronized int read() throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                return buf.get() & 0xFF;
            }

            public synchronized int read(byte[] bytes, int off, int len) throws IOException {
                len = Math.min(len, buf.remaining());
                buf.get(bytes, off, len);
                return len;
            }
        };
    }
}

