/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.commoncrawl.hadoop.io.ARCResource;
import org.commoncrawl.hadoop.io.ARCSource;
import org.commoncrawl.hadoop.io.ARCSplitCalculator;
import org.commoncrawl.util.shared.EscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalARCSource
extends ARCSplitCalculator
implements ARCSource,
JobConfigurable {
    public static final String P_INPUTS = "local.arc.source.inputs";

    public static void setInputs(JobConf job, String ... paths) {
        job.set(P_INPUTS, EscapeUtils.concatenate(',', paths));
    }

    public static String[] getInputs(JobConf job) {
        String inputs = job.get(P_INPUTS);
        return inputs == null ? null : EscapeUtils.split(',', inputs);
    }

    @Override
    protected Collection<ARCResource> getARCResources(JobConf job) throws IOException {
        String[] inputs = LocalARCSource.getInputs(job);
        if (inputs == null) {
            throw new IllegalArgumentException("No inputs set");
        }
        HashMap<String, ARCResource> resources = new HashMap<String, ARCResource>();
        for (String input : inputs) {
            File[] files;
            File[] fileArray;
            File file = new File(input);
            if (file.isDirectory()) {
                fileArray = file.listFiles();
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = file;
            }
            for (File f : files = fileArray) {
                String path = f.getCanonicalPath();
                resources.put(path, new ARCResource(path, f.length()));
            }
        }
        return resources.values();
    }

    @Override
    public InputStream getStream(String resource, long streamPosition, Throwable lastError, int previousFailures) throws Throwable {
        if (lastError != null || previousFailures > 0) {
            return null;
        }
        if (streamPosition != 0L) {
            throw new RuntimeException("Non-zero position requested");
        }
        return new FileInputStream(resource);
    }
}

