/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.util.StringUtils;
import org.commoncrawl.hadoop.io.ARCResource;
import org.commoncrawl.hadoop.io.ARCSource;
import org.commoncrawl.hadoop.io.ARCSplit;
import org.commoncrawl.protocol.shared.ArcFileItem;
import org.commoncrawl.util.shared.ArcFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARCSplitReader
implements RecordReader<Text, ArcFileItem> {
    private static final Log LOG = LogFactory.getLog(ARCSplitReader.class);
    public static final String SPLIT_DETAILS = "arc.reader.split.details";
    private ARCSplit split;
    private ARCSource source;
    private int blockSize;
    private ArcFileReader[] readers;
    private int readerIndex;
    private long totalBytesRead;
    private Throwable error;

    public ARCSplitReader(JobConf job, ARCSplit split, ARCSource source, int blockSize) {
        this.split = split;
        job.set(SPLIT_DETAILS, split.toString());
        this.source = source;
        this.blockSize = blockSize;
        this.readers = new ArcFileReader[split.getResources().length];
        this.readers[0] = new ArcFileReader();
        this.readerIndex = 0;
        this.totalBytesRead = 0L;
        this.error = null;
        new IOThread().start();
    }

    public boolean next(ArcFileItem item) throws IOException {
        while (this.readerIndex < this.readers.length) {
            if (this.readers[this.readerIndex].hasMoreItems()) {
                item.setArcFileName(this.split.getResources()[this.readerIndex].getName());
                try {
                    this.readers[this.readerIndex].getNextItem(item);
                }
                catch (IOException e) {
                    LOG.error((Object)("IOException in ARCSplitReader.next().ArcFile:" + item.getArcFileName() + "\nException:" + StringUtils.stringifyException((Throwable)e)));
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Object)("Unknown Exception thrown in ARCSplitReader.next().ArcFile:" + item.getArcFileName() + "\nException:" + StringUtils.stringifyException((Throwable)e)));
                    throw new RuntimeException(e);
                }
                return true;
            }
            this.readers[this.readerIndex++] = null;
        }
        return false;
    }

    public boolean next(Text key, ArcFileItem value) throws IOException {
        if (this.next(value)) {
            key.set(value.getUri());
            value.setFieldClean(1);
            return true;
        }
        return false;
    }

    public Text createKey() {
        return new Text();
    }

    public ArcFileItem createValue() {
        return new ArcFileItem();
    }

    public long getPos() throws IOException {
        return this.totalBytesRead;
    }

    public float getProgress() throws IOException {
        return (float)this.totalBytesRead / (float)this.split.getLength();
    }

    public void close() throws IOException {
    }

    private class IOThread
    extends Thread {
        private IOThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block14: for (int i = 0; i < ARCSplitReader.this.readers.length; ++i) {
                ARCResource resource = ARCSplitReader.this.split.getResources()[i];
                ArcFileReader reader = ARCSplitReader.this.readers[i];
                InputStream stream = null;
                long streamPosition = 0L;
                int failures = 0;
                Throwable lastError = null;
                while (true) {
                    try {
                        stream = ARCSplitReader.this.source.getStream(resource.getName(), streamPosition, lastError, failures);
                        if (stream == null) {
                            LOG.fatal((Object)"IOThread exiting", lastError);
                            ARCSplitReader.this.error = lastError;
                            return;
                        }
                        ReadableByteChannel channel = Channels.newChannel(stream);
                        while (true) {
                            ByteBuffer buffer;
                            int bytesRead;
                            if ((bytesRead = channel.read(buffer = ByteBuffer.allocate(ARCSplitReader.this.blockSize))) > 0) {
                                streamPosition += (long)bytesRead;
                                ARCSplitReader.this.totalBytesRead += bytesRead;
                                buffer.flip();
                                reader.available(buffer);
                                continue;
                            }
                            if (bytesRead == -1) break;
                        }
                        if (i + 1 < ARCSplitReader.this.readers.length) {
                            ((ARCSplitReader)ARCSplitReader.this).readers[i + 1] = new ArcFileReader();
                        }
                        reader.finished();
                        continue block14;
                    }
                    catch (Throwable t1) {
                        lastError = t1;
                        ++failures;
                        continue;
                    }
                    finally {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (Throwable t2) {}
                        stream = null;
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

