/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.commoncrawl.hadoop.io.ARCResource;

public class ARCSplit
implements InputSplit {
    private ARCResource[] resources;
    private long size;
    private String[] hosts;

    public ARCSplit() {
    }

    public ARCSplit(ARCResource[] resources) {
        this(resources, new String[0]);
    }

    public ARCSplit(ARCResource[] resources, String[] hosts) {
        this.resources = resources;
        this.hosts = hosts;
        for (ARCResource resource : resources) {
            this.size += resource.getSize();
        }
    }

    public ARCResource[] getResources() {
        return this.resources;
    }

    public long getLength() throws IOException {
        return this.size;
    }

    public String[] getLocations() throws IOException {
        return this.hosts;
    }

    public String toString() {
        return "Resources: " + Arrays.toString(this.resources) + " Size: " + this.size + " Hosts: " + Arrays.toString(this.hosts);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.resources.length);
        for (ARCResource resource : this.resources) {
            resource.write(out);
        }
        out.writeLong(this.size);
    }

    public void readFields(DataInput in) throws IOException {
        int nResources = in.readInt();
        this.resources = new ARCResource[nResources];
        for (int i = 0; i < nResources; ++i) {
            this.resources[i] = new ARCResource(Text.readString((DataInput)in), in.readLong());
        }
        this.size = in.readLong();
        this.hosts = null;
    }
}

