/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.async;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Timer
implements Comparable<Timer> {
    private long _delay;
    private boolean _periodic;
    private long _nextFireTime = 0L;
    private Callback _callback;

    public Timer(long delay, boolean periodic, Callback callback) {
        this._delay = delay;
        this._periodic = periodic;
        this._callback = callback;
    }

    public long getDelay() {
        return this._delay;
    }

    public boolean isPeriodic() {
        return this._periodic;
    }

    public boolean isArmed() {
        return this._nextFireTime != 0L;
    }

    long getNextFireTime() {
        return this._nextFireTime;
    }

    void fire() {
        if (this._periodic) {
            this.arm();
        } else {
            this.disarm();
        }
        this._callback.timerFired(this);
    }

    void arm() {
        this._nextFireTime = System.currentTimeMillis() + this._delay;
    }

    void disarm() {
        this._nextFireTime = 0L;
    }

    public void rearm() {
        this.arm();
    }

    @Override
    public int compareTo(Timer t) {
        if (this._nextFireTime < t._nextFireTime) {
            return -1;
        }
        if (this._nextFireTime > t._nextFireTime) {
            return 1;
        }
        return 0;
    }

    public static interface Callback {
        public void timerFired(Timer var1);
    }
}

