/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.async;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.commoncrawl.async.Callbacks;
import org.commoncrawl.async.Timer;
import org.commoncrawl.async.TimerRegistry;
import org.commoncrawl.io.internal.NIODNSLocalResolver;
import org.commoncrawl.io.internal.NIOSocketSelector;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventLoop
implements Runnable {
    private static final Log LOG = LogFactory.getLog(EventLoop.class);
    ExecutorService _resolverThreadPool = null;
    NIODNSLocalResolver _resolver;
    NIOSocketSelector _selector;
    Thread _eventThread;
    TimerRegistry _timerRegistry = new TimerRegistry(this);
    boolean _shutdown = false;
    long _loopCount = 0L;
    NIOSocketSelector.TimeUsageDetail _selectorTimeUsage = new NIOSocketSelector.TimeUsageDetail();

    public EventLoop() throws IOException {
        this.init(null);
    }

    public EventLoop(ExecutorService resolverThreadPool) throws IOException {
        this.init(resolverThreadPool);
    }

    private void init(ExecutorService resolverThreadPool) {
        try {
            this._selector = new NIOSocketSelector(this);
            this._resolverThreadPool = resolverThreadPool;
        }
        catch (IOException e) {
            LOG.fatal((Object)"Unable to initialize NIO Selector");
            throw new RuntimeException("Unable to initialize NIO Selector");
        }
    }

    public NIOSocketSelector getSelector() {
        return this._selector;
    }

    public NIODNSLocalResolver getResolver() {
        if (this._resolver == null) {
            if (this._resolverThreadPool == null) {
                this._resolverThreadPool = Executors.newFixedThreadPool(1);
            }
            this._resolver = new NIODNSLocalResolver(this, this._resolverThreadPool, true);
        }
        return this._resolver;
    }

    public void start() {
        if (this._eventThread != null) {
            LOG.fatal((Object)"Invalid Call State");
            throw new RuntimeException("Invalid Call State");
        }
        this._shutdown = false;
        this._eventThread = new Thread(this);
        this._eventThread.start();
    }

    public void stop() {
        if (this._eventThread == null) {
            throw new RuntimeException("Invalid Call State");
        }
        this._shutdown = true;
        try {
            this._selector.wakeup();
        }
        catch (IOException e) {
            LOG.fatal((Object)"IOException encountered in Selector.wakeup!");
            throw new RuntimeException(e);
        }
        if (Thread.currentThread() != this._eventThread) {
            try {
                LOG.info((Object)("Waiting for Event Thread to DIE TID:" + Thread.currentThread().getId()));
                this._eventThread.join();
                this._eventThread = null;
                LOG.info((Object)("Event Thread DEAD. Exiting EventLoop TID:" + Thread.currentThread().getId()));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isRunning() {
        return this._eventThread != null && this._eventThread.isAlive();
    }

    public void wakeup() {
        if (this._selector != null) {
            try {
                this._selector.wakeup();
            }
            catch (IOException e) {
                LOG.fatal((Object)"IOException encountered in Selector.wakeup!");
                throw new RuntimeException(e);
            }
        }
    }

    public Thread getEventThread() {
        return this._eventThread;
    }

    public boolean waitForIO(long waitTime) throws IOException {
        long timeStart = System.currentTimeMillis();
        long timeEnd = timeStart + waitTime;
        while (!this._shutdown) {
            long nextFireTime = this._timerRegistry.fireTimers();
            waitTime = timeEnd - System.currentTimeMillis();
            if (waitTime <= 0L) break;
            if (nextFireTime != 0L) {
                waitTime = Math.max(1L, Math.min(nextFireTime - System.currentTimeMillis(), waitTime));
            }
            if (this._selector.poll(waitTime, this._selectorTimeUsage) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (!this._shutdown) {
                    long waitTime = Long.MAX_VALUE;
                    long nextFireTime = this._timerRegistry.fireTimers();
                    if (nextFireTime != 0L) {
                        waitTime = Math.max(1L, nextFireTime - System.currentTimeMillis());
                    }
                    try {
                        if (this._resolver != null) {
                            this._resolver.poll();
                        }
                        this._selector.poll(waitTime, this._selectorTimeUsage);
                        continue block4;
                    }
                    catch (IOException e) {
                        LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                        e.printStackTrace();
                    }
                }
                break;
            }
            catch (Exception e) {
                LOG.fatal((Object)("Unhandled Exception in Event Loop:" + StringUtils.stringifyException((Throwable)e)));
                System.out.println("Unhandled Exception in Event Loop:" + StringUtils.stringifyException((Throwable)e));
                break;
            }
        }
        LOG.info((Object)"Event Loop Existing Run Loop");
    }

    public void setTimer(Timer t) {
        this._timerRegistry.setTimer(t);
    }

    public void cancelTimer(Timer t) {
        this._timerRegistry.cancelTimer(t);
    }

    public void queueAsyncRunnable(final Runnable runnable) {
        this.setTimer(new Timer(0L, false, new Timer.Callback(){

            public void timerFired(Timer timer) {
                runnable.run();
            }
        }));
    }

    public void queueAsyncCallback(final Callbacks.Callback callback) {
        this.setTimer(new Timer(0L, false, new Timer.Callback(){

            public void timerFired(Timer timer) {
                callback.execute();
            }
        }));
    }

    public <ResultType> void queueAsyncCallbackWithResult(final Callbacks.CallbackWithResult<ResultType> callback, final ResultType result) {
        this.setTimer(new Timer(0L, false, new Timer.Callback(){

            public void timerFired(Timer timer) {
                callback.execute(result);
            }
        }));
    }

    @Test
    public void testEventLoop() throws Exception {
        final EventLoop eventLoop = new EventLoop();
        eventLoop.start();
        eventLoop.setTimer(new Timer(1000L, false, new Timer.Callback(){

            public void timerFired(Timer timer) {
                System.out.println("Timer 1 Fired");
            }
        }));
        eventLoop.setTimer(new Timer(500L, false, new Timer.Callback(){

            public void timerFired(Timer timer) {
                System.out.println("Timer 2 Fired");
            }
        }));
        eventLoop.setTimer(new Timer(3000L, false, new Timer.Callback(){

            public void timerFired(Timer timer) {
                System.out.println("Timer 3 Fired");
                eventLoop.stop();
            }
        }));
        System.out.println("Wait for Timer to Fire");
        eventLoop.getEventThread().join();
        System.out.println("Event loop stopped. Shutting down.");
    }
}

