/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.async;

import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.async.Timer;
import org.commoncrawl.util.shared.CCStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncTask {
    private static final Log LOG = LogFactory.getLog(AsyncTask.class);

    public static void runAsyncTask(EventLoop eventLoop, final Runnable task, boolean waitForResult) {
        if (eventLoop.getEventThread() == Thread.currentThread()) {
            try {
                task.run();
            }
            catch (Exception e) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            }
        } else {
            final Semaphore blockingSemaphore = new Semaphore(0);
            Timer timer = new Timer(0L, false, new Timer.Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void timerFired(Timer timer) {
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    }
                    finally {
                        blockingSemaphore.release();
                    }
                }
            });
            eventLoop.setTimer(timer);
            try {
                if (waitForResult) {
                    blockingSemaphore.acquire();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public static <ResultType> ResultType runAsyncTaskWithResult(EventLoop eventLoop, final Callable<ResultType> callable) {
        if (eventLoop.getEventThread() == Thread.currentThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                return null;
            }
        }
        final Semaphore blockingSemaphore = new Semaphore(0);
        final ResultContainer resultContainer = new ResultContainer();
        Timer timer = new Timer(0L, false, new Timer.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void timerFired(Timer timer) {
                try {
                    resultContainer.setResult(callable.call());
                }
                catch (Exception e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                }
                finally {
                    blockingSemaphore.release();
                }
            }
        });
        eventLoop.setTimer(timer);
        try {
            blockingSemaphore.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return resultContainer.getResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResultContainer<ResultType> {
        private ResultType result = null;

        ResultContainer() {
        }

        void setResult(ResultType result) {
            this.result = result;
        }

        ResultType getResult() {
            return this.result;
        }
    }
}

