#!/usr/bin/env python3

# sudo apt-get install python3 python3-matplotlib python3-numpy

import matplotlib.pyplot as plt
import math
import socket
import struct
import sys
import time

#######################
# User Options:
listen_port = 2345
dest_ip = "127.0.0.1"
dest_port = 3456
#######################

print("Running Python relay")

# Setup UDP socket to receive data on the 'listen_port'
s_recv = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

try:
    s_recv.bind(("",listen_port))
except socket.error as message:
    print("Error binding to listening port")
    print(message)
    sys.exit

# Setup UDP socket to transmit data to 'dest_ip' / 'dest_port'
s_send = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
dest_addr = (dest_ip, dest_port)

try:
    s_send.bind(('', 0))  # Any port is fine...
except socket.error as message:
    print("Error binding to any port")
    print(message)
    sys.exit

# Setup top and bottom figures
plt.ion()   # Enter interactive mode
fig = plt.figure()
ax1 = fig.add_subplot(211)
ax1.set_title('Relay INPUT Data')
ax1.set_ylim(-2, 2)
ax2 = fig.add_subplot(212)
ax2.set_title('Relay OUTPUT Data (Sending to ' + dest_ip + ':' + str(dest_port) + ')')

ax2.set_ylim(-2, 2)

# Create new lists containing zero and plot them
max_elements = 75
full_x_in = [0]
full_y_in = [0]
full_x_out = [0]
full_y_out = [0]
line1, = ax1.plot(full_x_out, full_y_out, marker='o')
line2, = ax2.plot(full_x_out, full_y_out, marker='o')

# Feed in new data slowly
while True:
    (raw_data, addr) = s_recv.recvfrom(1024)

    # Unpack new data
    in_x, in_y = struct.unpack("!ff", raw_data)

    # Display the new data
    # Append new element to end of list,
    # while dropping first element at same time
    full_x_in = full_x_in + [in_x]
    full_y_in = full_y_in + [in_y]
    if(len(full_x_in) > max_elements):
        del full_x_in[0:len(full_x_in)-max_elements]
    if(len(full_y_in) > max_elements):
        del full_y_in[0:len(full_y_in)-max_elements]
    line1.set_xdata(full_x_in)
    line1.set_ydata(full_y_in)
    ax1.set_xlim(min(full_x_in),max(full_x_in))
    plt.draw()

    out_x = in_x
    out_y = in_y
#    out_y = math.cos(in_x)

    full_x_out = full_x_out + [out_x]
    full_y_out = full_y_out + [out_y]
    if(len(full_x_out) > max_elements):
        del full_x_out[0:len(full_x_out)-max_elements]
    if(len(full_y_out) > max_elements):
        del full_y_out[0:len(full_y_out)-max_elements]
    line2.set_xdata(full_x_out)
    line2.set_ydata(full_y_out)
    ax2.set_xlim(min(full_x_out),max(full_x_out))
    plt.draw()

    # Relay the data on to the next computer. 
    # Pack the two new float into a small packet.
    packet = struct.pack("!ff", out_x, out_y)
    s_send.sendto(packet, dest_addr)

    # Wait a bit before repeating
    time.sleep(0.05)
