#!/usr/bin/env python3

# sudo apt-get install python3 python3-matplotlib python3-numpy

import matplotlib.pyplot as plt
import math
import socket
import struct
import sys
import time

#######################
# User Options:
dest_ip = "127.0.0.1"
dest_port = 2345
#######################

print("Running Python data generator")

# Setup UDP socket to transmit data
s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
dest_addr = (dest_ip, dest_port)

try:
    s.bind(('', 0))  # Any port is fine...
except socket.error as message:
    print("Error binding to any port")
    print(message)
    sys.exit

# Setup figure
plt.ion()   # Enter interactive mode
fig = plt.figure()
ax = fig.add_subplot(111)
ax.set_title('Input Data\n(Sending to ' + dest_ip + ':' + str(dest_port) + ')')
ax.set_ylim(-2, 2)

# Create a list containing zero and plot it
x = [0]
y = [0]
line, = ax.plot(x,y,marker='o')

step_size = 0.1
max_elements = 75
new_x = 0.0

# Feed in new data slowly
while True:
    new_x = new_x + step_size
    new_y = math.sin(new_x)

    # Append new element to end of list,
    # while dropping first element of list
    # if we have more than max_elements
    x = x + [new_x]
    y = y + [new_y]
    if(len(x) > max_elements):
        del x[0:len(x)-max_elements]
    if(len(y) > max_elements):
        del y[0:len(y)-max_elements]

    # Update plot
    line.set_xdata(x)
    line.set_ydata(y)
    ax.set_xlim(min(x),max(x))
    plt.draw()

    # Pack the two new float into a small packet
    # and transmit it
    packet = struct.pack("!ff", new_x, new_y)
    s.sendto(packet, dest_addr)

    # Wait a bit before repeating
    time.sleep(0.1)
