#!/usr/bin/env python3

# sudo apt-get install python3 python3-matplotlib python3-numpy

import matplotlib.pyplot as plt
import math
import socket
import struct
import sys
import time

#######################
# User Options:
listen_port = 3456
#######################

print("Running Python endpoint")

# Setup UDP socket to receive data on the 'listen_port'
s_recv = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

try:
    s_recv.bind(("",listen_port))
except socket.error as message:
    print("Error binding to listening port")
    print(message)
    sys.exit


# Setup figure
plt.ion()   # Enter interactive mode
fig = plt.figure()
ax = fig.add_subplot(111)
ax.set_title('Output Data')
ax.set_ylim(-2, 2)

# Create new lists containing zero and plot them
max_elements = 75
full_x = [0]
full_y = [0]
line1, = ax.plot(full_x, full_y, marker='o')

# Feed in new data slowly
while True:
    (raw_data, addr) = s_recv.recvfrom(1024)

    # Unpack new data
    x, y = struct.unpack("!ff", raw_data)

    # Display the new data
    # Append new element to end of list,
    # while dropping first element at same time
    full_x = full_x + [x]
    full_y = full_y + [y]
    if(len(full_x) > max_elements):
        del full_x[0:len(full_x)-max_elements]
    if(len(full_y) > max_elements):
        del full_y[0:len(full_y)-max_elements]
    line1.set_xdata(full_x)
    line1.set_ydata(full_y)
    ax.set_xlim(min(full_x),max(full_x))
    plt.draw()

    # Wait a bit before repeating
    time.sleep(0.05)
